﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using AntiXssEnc = Microsoft.Security.Application;

public partial class TBICubeInfo : System.Web.UI.Page
{
    private UserAccountManager _currentUser;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!AccessAllowed())
        {
            Response.Redirect("ErrorPage.aspx?id=100");
        }
        else
        {
            if (!Page.IsPostBack)
            {
                string cubeLastUpdateDate = "N/A";
                string reportBuilder = "N/A";
                string excelInstructions = "N/A";

                CrsSettingsManager manager = new CrsSettingsManager();
                List<CRS_SETTINGS> list = manager.GetTbiCubeSettings();
                if (list != null)
                {
                    foreach (CRS_SETTINGS setting in list)
                    {
                        switch (setting.NAME)
                        {
                            case "Cube Last Update":
                                cubeLastUpdateDate = setting.VALUE;
                                break;
                            case "Report Builder URL":
                                reportBuilder = "<a href='" + setting.VALUE + "' target='_blank'>Click here to open Report Builder</a>";
                                break;
                            case "Cube Excel Instructions":
                                excelInstructions = "<a href='" + setting.VALUE + "' target='_blank'>Click here to open Excel Instructions</a>";
                                break;
                            default:
                                break;
                        }
                    }
                }

                lblCubeLastUpdateDate.Text = AntiXssEnc.Encoder.HtmlEncode(cubeLastUpdateDate);
                lblReportBuilder.Text = AntiXssEnc.Encoder.HtmlEncode(reportBuilder);
                lblExcelInstructions.Text = AntiXssEnc.Encoder.HtmlEncode(excelInstructions);
            }
        }
    }

    private bool AccessAllowed()
    {
        _currentUser = (UserAccountManager)HttpContext.Current.User;
        return (_currentUser.IsInRole(16) || _currentUser.IsInRole(17) || _currentUser.IsInRole(18));
    }
}